/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib;

import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import org.jwaresoftware.mcmods.lib.StubbornPotionEffect;

public class MagnifyingPotionEffect
extends StubbornPotionEffect {
    private static final int _MAX_AMPLIFIER = 3;

    public MagnifyingPotionEffect(Potion potion, int duration, int amplifier, boolean ambient, boolean particles) {
        super(potion, duration, amplifier, ambient, particles);
    }

    public MagnifyingPotionEffect(Potion potion, int duration, int amplifier) {
        super(potion, duration, amplifier);
    }

    public MagnifyingPotionEffect(StubbornPotionEffect from) {
        super(from);
    }

    @Override
    public String getType() {
        return "magnifier";
    }

    @Override
    protected PotionEffect combineInternal(PotionEffect other) {
        PotionEffect out = null;
        if (other.func_188419_a() == this.func_188419_a()) {
            int new_amplifier = other.func_76458_c();
            int cur_amplifier = this.func_76458_c();
            if (new_amplifier < 0 || cur_amplifier < 0) {
                return other;
            }
            if (new_amplifier == 0) {
                new_amplifier = Math.min(cur_amplifier + 1, 3);
                out = new PotionEffect(this.func_188419_a(), this.func_76459_b(), new_amplifier, other.func_82720_e(), other.func_188418_e());
            } else if (new_amplifier > cur_amplifier) {
                new_amplifier = Math.min(cur_amplifier + (new_amplifier - cur_amplifier) + 1, 3);
                int new_duration = Math.min(this._original_duration, other.func_76459_b() + this.func_76459_b());
                out = new PotionEffect(this.func_188419_a(), new_duration, new_amplifier, other.func_82720_e(), other.func_188418_e());
            }
        }
        if (out == null) {
            out = super.combineInternal(other);
        }
        return out;
    }
}

